(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6006,        180]*)
(*NotebookOutlinePosition[      6849,        207]*)
(*  CellTagsIndexPosition[      6805,        203]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\( (*\ 
      Example\ 2.2  .3 . \ \[IndentingNewLine]For\ Example\ 6.2  .1\ see\ the\
\ file\ galerkin6 . nb\ instead\ *) \)\(\[IndentingNewLine]\)\(residual = 
      c1*x + c2*x^2 + 
          c3*x^3 - \[Lambda] \((Integrate[
                  s*\((c1*\ s + c2*\ s^2 + c3\ *s^3)\), {s, \ 0, 
                    x}] + \n\t\t\t\t\tx*
                  Integrate[c1*s + c2*s^2 + c3*s^3, \ {s, x, 1}])\) // 
        Simplify\)\)\)], "Input"],

Cell[BoxData[
    \(1\/60\ x\ 
      \((5\ c2\ \((12\ x - 4\ \[Lambda] + x\^3\ \[Lambda])\) + 
          3\ c3\ \((20\ x\^2 - 5\ \[Lambda] + x\^4\ \[Lambda])\) + 
          10\ c1\ \((6 + \((\(-3\) + x\^2)\)\ \[Lambda])\))\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Eq\ \((1)\)\ *) \nIntegrate[residual\ *\ x, {x, \ 0, 1}]\)\)], 
  "Input"],

Cell[BoxData[
    \(c1\/3 + c2\/4 + c3\/5 - \(2\ c1\ \[Lambda]\)\/15 - 
      \(7\ c2\ \[Lambda]\)\/72 - \(8\ c3\ \[Lambda]\)\/105\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Eq\ \((2)\)\ *) \nIntegrate[residual\ *\ x^2, {x, \ 0, 1}]\)\)], 
  "Input"],

Cell[BoxData[
    \(c1\/4 + c2\/5 + c3\/6 - \(7\ c1\ \[Lambda]\)\/72 - 
      \(c2\ \[Lambda]\)\/14 - \(9\ c3\ \[Lambda]\)\/160\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Eq\ \((3)\)\ *) \nIntegrate[residual\ *\ x^3, {x, \ 0, 1}]\)\)], 
  "Input"],

Cell[BoxData[
    \(c1\/5 + c2\/6 + c3\/7 - \(8\ c1\ \[Lambda]\)\/105 - 
      \(9\ c2\ \[Lambda]\)\/160 - \(2\ c3\ \[Lambda]\)\/45\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ To\ solve\ the\ system\ for\ c1, \ c2, \ c3\ \ *) \n
    a = {{1/3 - 2\ \ \[Lambda]/15, \ 1/4 - 7\ \ \[Lambda]/72, \ 
          1/5 - 8\ \ \[Lambda]/105}, \n
        \t\t{1/4 - 7\ \ \[Lambda]/\ 72, \ 1/5 - \ \[Lambda]/14, \ 
          1/6 - 9\ \ \[Lambda]/160}, \n
        \t\t{1/5 - 8\ \ \[Lambda]/105, \ 1/6 - 9\ \ \[Lambda]/160, \ 
          1/7 - 2\ \ \[Lambda]/45}}\)\)], "Input"],

Cell[BoxData[
    \({{1\/3 - \(2\ \[Lambda]\)\/15, 1\/4 - \(7\ \[Lambda]\)\/72, 
        1\/5 - \(8\ \[Lambda]\)\/105}, {1\/4 - \(7\ \[Lambda]\)\/72, 
        1\/5 - \[Lambda]\/14, 1\/6 - \(9\ \[Lambda]\)\/160}, {
        1\/5 - \(8\ \[Lambda]\)\/105, 1\/6 - \(9\ \[Lambda]\)\/160, 
        1\/7 - \(2\ \[Lambda]\)\/45}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[a]\)], "Input"],

Cell[BoxData[
    \(1\/378000 - \(13\ \[Lambda]\)\/10584000 + 
      \(11\ \[Lambda]\^2\)\/169344000 - \(11\ \[Lambda]\^3\)\/16003008000\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[a] == 0]\)], "Input"],

Cell[BoxData[
    \({{\[Lambda] \[Rule] 
          63\/2 + \(3\ \((7\ \((25795 + 32\ I\ \@948409)\))\)\^\(1/3\)\)\/\(2
                \ 11\^\(2/3\)\) + 
            \(831\ 7\^\(2/3\)\)\/\(2\ 
                \((11\ \((25795 + 32\ I\ \@948409)\))\)\^\(1/3\)\)}, {
        \[Lambda] \[Rule] 
          63\/2 - \(3\ \((1 + I\ \@3)\)\ 
                \((7\ \((25795 + 32\ I\ \@948409)\))\)\^\(1/3\)\)\/\(4\ 
                11\^\(2/3\)\) - 
            \(831\ 7\^\(2/3\)\ \((1 - I\ \@3)\)\)\/\(4\ 
                \((11\ \((25795 + 32\ I\ \@948409)\))\)\^\(1/3\)\)}, {
        \[Lambda] \[Rule] 
          63\/2 - \(3\ \((1 - I\ \@3)\)\ 
                \((7\ \((25795 + 32\ I\ \@948409)\))\)\^\(1/3\)\)\/\(4\ 
                11\^\(2/3\)\) - 
            \(831\ 7\^\(2/3\)\ \((1 + I\ \@3)\)\)\/\(4\ 
                \((11\ \((25795 + 32\ I\ \@948409)\))\)\^\(1/3\)\)}}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \({{\[Lambda] \[Rule] 
          \(69.6313827127109341`\[InvisibleSpace]\) + 
            3.55271367880050092`*^-15\ I}, {
        \[Lambda] \[Rule] 
          \(22.4012112920848771`\[InvisibleSpace]\) - 
            1.42108547152020037`*^-14\ I}, {
        \[Lambda] \[Rule] 
          \(2.46740599520419578`\[InvisibleSpace]\) + 
            8.88178419700125232`*^-15\ I}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ The\ eigenvalues\ are\ \ *) \n\[Lambda]1 = 2.46740599520419578`; 
    \n\[Lambda]2 = \ 22.4012112920848771`; \n
    \[Lambda]3\  = 69.6313827127109341`\[InvisibleSpace]; \)\)], "Input"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 462, 9, 187, "Input"],
Cell[2204, 62, 238, 4, 60, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2479, 71, 101, 2, 43, "Input"],
Cell[2583, 75, 144, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2764, 82, 103, 2, 43, "Input"],
Cell[2870, 86, 141, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3048, 93, 103, 2, 43, "Input"],
Cell[3154, 97, 145, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3336, 104, 412, 7, 75, "Input"],
Cell[3751, 113, 334, 5, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4122, 123, 39, 1, 27, "Input"],
Cell[4164, 126, 153, 3, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4354, 134, 51, 1, 27, "Input"],
Cell[4408, 137, 884, 18, 294, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5329, 160, 37, 1, 27, "Input"],
Cell[5369, 163, 406, 9, 45, "Output"]
}, Open  ]],
Cell[5790, 175, 212, 3, 75, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

